% -------------------------------------------------------------------
% Este script resuelve la ecuacin para la desintegracin de una
% especie radiactiva usando el mtodo de Euler implcito.
% Este script requiere que en el espacio de trabajo exista la
% funcin bfeuler.
% dy/dx = f(x,y;k) = - k*y:
% -------------------------------------------------------------------

Definiciones y parmetros

k=1;
g = @(t,y) -k*y;
y0=100;
t0=0;
tf=5;
Nh=10;

Solucim mediante el mtodo de Euler implcito

[t,y]=bfeuler(g,t0,tf,y0,Nh);

Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.
Optimization terminated: first-order optimality is less than options.TolFun.

Encuentro la solucin exacta

tp=0:0.1:5;
yp=y0*exp(-k*tp);

Representacin grfica

plot(tp,yp,t,y,'o','MarkerEdgeColor','r');
xlabel('t');
ylabel('N');
title('Mtodo de Euler implcito');
legend('Sol. exacta','Sol. numrica');
text(2,70,'k=1, Nh=10');
